%This program is used to compute the W_i in (3) of our paper.
%x0 is a scalar
%x are the raw data
%h is the bandwidth
%r is the covariance of each subject among different time points
function w=Weight_1_i(x0,x,h,r)%x0 is a point
n=length(x(1,:));
J=length(x(:,1));
w=zeros(J,J,n);
%  r=COV_R(x,y,h,typ);
 I0=(abs(x-x0)<(h*ones(J,n)));
 K0=3/4.*(1-((x-x0)./h)).^2./h.*I0;
 for i=1:n
 w(1:J,1:J,i)=diag(K0(:,i))^(1/2)*pinv(diag(I0(:,i))*r(:,:,i)*diag(I0(:,i)))*diag(K0(:,i))^(1/2);
 end
 